# 画面設計書 19-GLTF Import Dialog

## 概要

本ドキュメントは、three.js エディタにおけるGLTFインポートダイアログ（GLTF Import Dialog）の画面設計書である。このダイアログは、GLTF/GLBファイルをインポートする際のオプション設定を行うためのモーダルダイアログである。

### 本画面の処理概要

**業務上の目的・背景**：GLTF（GL Transmission Format）は、3Dモデルの交換フォーマットとして広く使用されている。GLTFファイルをインポートする際、シーン全体として読み込むか、個別オブジェクトとして追加するかなど、用途に応じた設定が必要となる場合がある。このダイアログは、インポート時のオプションを設定するためのユーザーインターフェースを提供する。

**画面へのアクセス方法**：File > Import > GLTFメニュー操作時、またはGLTF/GLBファイルをエディタにドラッグ&ドロップした際に自動的に表示される。

**主要な操作・処理内容**：
1. **As Scene オプション**：チェックボックスでインポートをシーン置換として行うかを選択
2. **OK**：設定を確定してインポートを実行
3. **Cancel**：インポートをキャンセル

**画面遷移**：OKクリックでダイアログが閉じ、インポート処理が実行される。Cancelクリックまたは背景クリックでダイアログが閉じ、インポートがキャンセルされる。

**権限による表示制御**：特別な権限制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 104 | ObjectLoader | 主機能 | GLTFファイルのインポート処理 |
| 99 | LoadingManager | 補助機能 | インポート進捗管理 |

## 画面種別

モーダルダイアログ

## URL/ルーティング

エディタメイン画面の一部として動的に表示される。独立したルーティングは持たない。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | デフォルト値 | 説明 |
|--------|----------|---------|-------------|------|
| asScene | 入力 | Boolean | false | シーンとしてインポートするか |

## 表示項目

| 項目 | 表示内容 | 説明 |
|------|---------|------|
| タイトルバー | "GLTF Import" | ダイアログタイトル |
| As Sceneチェックボックス | チェックボックス + ラベル | インポートオプション |
| OKボタン | "OK" | 設定確定 |
| Cancelボタン | "Cancel" | キャンセル |
| 背景オーバーレイ | 半透明背景 | クリックでキャンセル |

## イベント仕様

### 1-show（ダイアログ表示）

- **トリガー**：GLTFImportDialog.show() が呼ばれた時
- **処理内容**：
  1. ダイアログDOM要素をdocument.bodyに追加
  2. Promiseを返す（resolve/rejectハンドラを保持）
- **画面更新**：ダイアログがモーダル表示される

### 2-confirm（設定確定）

- **トリガー**：OKボタンクリック
- **処理内容**：
  1. `asScene` の値を取得
  2. ダイアログDOMを削除
  3. Promiseをresolve（設定オブジェクトを返す）
- **画面更新**：ダイアログが閉じる

### 3-cancel（キャンセル）

- **トリガー**：Cancelボタンクリックまたは背景クリック
- **処理内容**：
  1. ダイアログDOMを削除
  2. Promiseをreject（Error: 'Import cancelled'）
- **画面更新**：ダイアログが閉じる

## データベース更新仕様

本画面はブラウザ上で動作する3Dエディタであり、データベースへの直接的な更新は行わない。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| なし | - | 本ダイアログでは特別なメッセージ表示はない |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| キャンセル時 | Error('Import cancelled')をthrow（呼び出し側でcatch） |

## 備考

- ダイアログはPromiseベースで実装されており、非同期処理として扱える
- 背景クリックでもキャンセルできる（ユーザビリティ向上）
- 多言語対応のため、すべてのテキストは`strings.getKey()`で取得される
- CSSクラス`Dialog`, `Dialog-background`, `Dialog-content`, `Dialog-title`, `Dialog-body`, `Dialog-buttons`を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GLTFImportDialog.js | `editor/js/GLTFImportDialog.js` | ダイアログの構造と処理フロー |

**主要処理フロー**:
1. **5-67行目**: constructor - DOM構造の構築
2. **9-16行目**: ダイアログとオーバーレイの作成
3. **22-27行目**: タイトルバーの作成
4. **29-43行目**: ボディ部分（As Sceneチェックボックス）の作成
5. **45-60行目**: ボタン行（OK/Cancel）の作成
6. **69-79行目**: show() - ダイアログ表示とPromise返却
7. **82-96行目**: confirm() - 設定取得とresolve
8. **98-108行目**: cancel() - reject

**読解のコツ**: ダイアログはクラスベースで実装されており、show()でPromiseを返す非同期パターンを使用している。

#### Step 2: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Menubar.File.js | `editor/js/Menubar.File.js` | GLTFImportDialogの使用箇所 |

### プログラム呼び出し階層図

```
Menubar.File.js (or Loader.js)
    │
    └─ new GLTFImportDialog(strings)
           │
           └─ dialog.show()
                  │
                  ├─ document.body.appendChild(dialog.dom)
                  │
                  └─ return new Promise((resolve, reject) => ...)
                         │
                         ├─ okButton.onClick()
                         │      └─ confirm()
                         │             ├─ result = { asScene: checkbox.getValue() }
                         │             ├─ dom.remove()
                         │             └─ resolve(result)
                         │
                         └─ cancelButton.onClick() or background.onClick()
                                └─ cancel()
                                       ├─ dom.remove()
                                       └─ reject(Error('Import cancelled'))
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ダイアログ表示 ─────────▶ GLTFImportDialog ─────────▶ Promise
                              │
ユーザー入力 ─────────────────┤
(asScene選択)                 │
                              ▼
                         confirm() or cancel()
                              │
                              ▼
                         resolve(result) or reject(error)
                              │
                              ▼
                         インポート処理継続 or 中止
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GLTFImportDialog.js | `editor/js/GLTFImportDialog.js` | ソース | ダイアログ実装 |
| ui.js | `editor/js/libs/ui.js` | ソース | UIコンポーネント（UIRow, UIText, UICheckbox, UIButton） |
| Menubar.File.js | `editor/js/Menubar.File.js` | ソース | ダイアログの呼び出し元 |
| Loader.js | `editor/js/Loader.js` | ソース | GLTFローダー実装 |
| main.css | `editor/css/main.css` | CSS | ダイアログスタイル |
